/*--------------------------------------------------------------------------------
	FILE:		utils.c
	
	PURPOSE:	Contains utility functions for the LED Open sign for initializing
				the microcontroller output pins and creating time delays.
				
	DATE:		9 September 2011, releases as open source on 22 September 2012
	
	DISCLAIMER:	This software is provided 'as-is', without any express or
				implied warranty.  In no event will the author(s) be held liable
				for any damages or loss arising from the use of this software.
				
	AUTHOR:		W.A. Smith
				startingelectronics.com
--------------------------------------------------------------------------------*/
#include <avr/io.h>
#include "utils.h"

void ChannelInit(void)
{
    /* set channel pins as outputs */
    DDRB = (1 << PB0) | (1 << PB1) | (1 << PB2) | (1 << PB3) | (1 << PB4);
    DDRD = (1 << PD2) | (1 << PD3) | (1 << PD4) | (1 << PD5) | (1 << PD6);
}

void Delay(volatile unsigned int del)
{
    while (del) {
        del--;
    }
}

void LongDelay(volatile unsigned int del)
{
    while (del) {
        Delay(0xA000);
        del--;
    }
}
