/*--------------------------------------------------------------------------------
	FILE:		open.c
	
	PURPOSE:	Contains functions for sequencing the LED "OPEN" text on the LED
				Open Sign. Contains functions for switching each individual
				letter on and off - i.e. O, P, E and N
				
	DATE:		9 September 2011, releases as open source on 22 September 2012
	
	DISCLAIMER:	This software is provided 'as-is', without any express or
				implied warranty.  In no event will the author(s) be held liable
				for any damages or loss arising from the use of this software.
				
	AUTHOR:		W.A. Smith
				startingelectronics.com
--------------------------------------------------------------------------------*/
#include <avr/io.h>
#include "open.h"
#include "utils.h"

#define LED_O   PB4
#define LED_P   PB3
#define LED_E   PB2
#define LED_N   PD5

void OpenSpeedUp(int del, unsigned int timeout)
{
    while (timeout) {
        OpenOff();
        Oon();
        Delay(del);
        OpenOff();
        Pon();
        Delay(del);
        OpenOff();
        Eon();
        Delay(del);
        OpenOff();
        Non();
        Delay(del);
        
        if (del > 1000) {
            del -= 1000;
        }
        else {
            timeout--;
        }
    }
    timeout = 100;
    while (timeout) {
        OpenOn();
        timeout--;
        Delay(1000);
    }
}

void OpenFlash(unsigned int speed, unsigned char times)
{
    while (times) {
        OpenOn();
        Delay(speed);
        OpenOff();
        Delay(speed);
        times--;
    }
}

void OpenDigitFlash(unsigned int del, unsigned char times)
{
    while (times) {
        Ooff();
        Delay(del);
        OpenOn();
        Poff();
        Delay(del);
        OpenOn();
        Eoff();
        Delay(del);
        OpenOn();
        Noff();
        Delay(del);
        OpenOn();
        times--;
    }
}

void OpenOn(void)
{
    Oon();
    Pon();
    Eon();
    Non();
}

void OpenOff(void)
{
    Ooff();
    Poff();
    Eoff();
    Noff();
}

void Oon(void)
{
    PORTB |= (1 << LED_O);
}

void Ooff(void)
{
    PORTB &= ~(1 << LED_O);
}
void Pon(void)
{
    PORTB |= (1 << LED_P);
}
void Poff(void)
{
    PORTB &= ~(1 << LED_P);
}
void Eon(void)
{
    PORTB |= (1 << LED_E);
}
void Eoff(void)
{
    PORTB &= ~(1 << LED_E);
}
void Non(void)
{
    PORTD |= (1 << LED_N);
}
void Noff(void)
{
    PORTD &= ~(1 << LED_N);
}
