/*--------------------------------------------------------------------------------
	FILE:		LED_sign_controller.c
	
	PURPOSE:	Sequences the LED patterns on the Open sign. Contains the main()
				function
				
	DATE:		9 September 2011, releases as open source on 22 September 2012
	
	DISCLAIMER:	This software is provided 'as-is', without any express or
				implied warranty.  In no event will the author(s) be held liable
				for any damages or loss arising from the use of this software.
				
	AUTHOR:		W.A. Smith
				startingelectronics.com
--------------------------------------------------------------------------------*/
#include <avr/io.h>
#include "line.h"
#include "open.h"
#include "utils.h"

void DisplayWave(int del, unsigned char times);

int main(void)
{
	int count;			// used in "for" loops

	ChannelInit();		// set up micro pins as outputs for driving LEDs
	
	// run through the LED pattern switching sequences continually
	while (1) {
		OpenSpeedUp(10000, 30);
		LineRotate(FORWARD, 10000, 20);
		LineOn(LINE_BOTH);
		OpenFlash(30000, 4);
		OpenOn();
		LongDelay(5);
		LineOff();
		LineRotate(REVERSE, 10000, 20);
		LineOn(LINE_BOTH);
		OpenDigitFlash(10000, 8);
		OpenOn();
		LongDelay(5);
		LineOff();
		LineToggle(10000, 10);
		LineOff();
		DualLineRotate(FORWARD, 30000, 10);
		OpenFlash(20000, 7);
		OpenOn();
		LongDelay(5);
		DualLineRotate(REVERSE, 7000, 20);
		FlashLines(10000, 8);
		DisplayWave(20000, 8);
		LineOff();
		OpenOn();
		LongDelay(5);
		LineRotate(FORWARD, 1000, 100);
		LineRotate(FORWARD, 8000, 20);
		LineRotate(FORWARD, 20000, 10);
		LineOn(LINE_BOTH);
		OpenDigitFlash(4000, 10);
		OpenSpeedUp(8000, 20);
		OpenOff();
		DualLineRotate(FORWARD, 7000, 5);
		OpenFlash(10000, 5);
		OpenOn();
		LineRotate(FORWARD, 5000, 10);
		LineRotate(REVERSE, 5000, 10);
		LineOff();
		LongDelay(2);
		OpenFlash(40000, 7);
		OpenOn();
		LineRotate(FORWARD, 4000, 10);
		LineRotate(REVERSE, 4000, 10);
		LineRotate(FORWARD, 3000, 10);
		LineRotate(REVERSE, 3000, 10);
		LineRotate(FORWARD, 2000, 20);
		LineRotate(REVERSE, 2000, 20);
		LineRotate(FORWARD, 1000, 20);
		LineRotate(REVERSE, 1000, 20);
		LineRotate(FORWARD,  900, 20);
		LineRotate(REVERSE,  900, 20);
		LineRotate(FORWARD,  800, 20);
		LineRotate(REVERSE,  800, 20);
		OpenOff();
		LineRotate(FORWARD,  800, 20);
		OpenOn();
		LineRotate(REVERSE,  800, 20);
		LineToggle(10000, 2);
		OpenOff();
		LineToggle(10000, 2);
		LineOff();
		for (count = 0; count < 5; count++) {
			LineOn(LINE_BOTH);
			OpenOn();
			LongDelay(5);
			LineOff();
			OpenOff();
			LongDelay(1);
		}
		for (count = 0; count < 5; count++) {
			OpenOn();
			LineOff();
			LongDelay(5);
			LineOn(LINE_BOTH);
			OpenOff();
			LongDelay(1);
		}
		OpenOff();
		LineToggle(8000, 4);
		LineOff();
	}
	return 0;
}

// function to switch between the top line of LEDs, the OPEN LED text and the bottom line
// has a "wave" effect as one element is switched on at a time in sequence
void DisplayWave(int del, unsigned char times)
{
	while (times) {
		LineOn(LINE_TOP);
		Delay(del);
		LineOff();
		OpenOn();
		Delay(del);
		OpenOff();
		LineOn(LINE_BOTTOM);
		Delay(del);
		times--;
	}
}
